 ; Ŀ
 ;   Tota - total the values of numbers in all selected text strings.      
 ;   Copyright 2004, 2006, 2008 by Rocket Software Ltd.                    
 ;   Sometimes you're confident, sometimes you think you've screwed up.    
 ;   But with a computer you're never sure.                                
 ; 

 ; Ŀ
 ;   Asla - total all number substrings in a text string.                  
 ;   Arguments: String, A text string.                                     
 ;   Calls Monster.                                                        
 ;   Returns a number or zero.                                             
 ; 
 (DEFUN ASLA (string / tao numa strlst)
  (setq tao 0)
  (setq strlst (monster string))
  (setq strlst (cdr strlst))
  (while (setq numa (car strlst))
         (setq strlst (cddr strlst))
         (setq numa (read numa))
         (if (member (type numa) '(REAL INT))
             (setq tao (+ numa tao))))
 tao)
 ; Ŀ
 ;   Asla end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine CI - grdraw circle maker.                                  
 ; 
 (DEFUN CI (pa radd colo / reps pa pa1 pa2 angg)
  (setq reps 32)
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (setq pa1 (polar pa angg radd))
  (repeat reps
          (setq angg (+ angg incr))
          (setq pa2 (polar pa angg radd))
          (grdraw pa1 pa2 colo)
          (setq pa1 pa2))
 (princ))
 ; Ŀ
 ;   Ci end.                                                               
 ; 

 ; Ŀ
 ;   Subroutine Crelm - replace the last number in a text string.          
 ;   Arguments: Rasp, a replacement number.                                
 ;              Proma, a prompt, if nil then use the string in Rasp.       
 ;   Calls Rlanun/Snortme/Monster & /Listi.                                
 ;   Returns the ename of the selected text or nil.                        
 ;   Breeds budgies.                                                       
 ; 
 (DEFUN CRELM (rasp proma / *error* snapp nent enam entt stra typ etype outer)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (defun *error* (shk /) (setvar "snapmode" snapp) (princ))
  (setq typ (type rasp))
  (if (null proma)
      (cond ((= typ 'int)
             (setq proma (strcat "Text <" (itoa rasp) ">: ")))
            ((= typ 'real)
             (setq proma (strcat "Text <" (rtos rasp) ">: ")))))
  (setq enam (car (setq nent (nentsel proma))))
  (setq etype (cdr (assoc 0 (setq entt (entget enam)))))
  (if (or (= "TEXT" etype) (= "MTEXT" etype)
          (= "ATTDEF" etype) (= "ATTRIB" etype))
      (progn
           (setq outer (car (reverse (car (reverse nent)))))
           (setq stra (cdr (assoc 1 entt)))
           (if (= stra "-")
               (cond ((= typ 'int)
                      (setq rasp (itoa rasp)))
                     ((= typ 'real)
                      (setq rasp (rtos rasp))))
               (setq rasp (rlanum stra rasp)))
           (entmod (subst (cons 1 rasp) (assoc 1 entt) entt))
           (entupd enam)
           (if (= (type outer) 'ENAME) (entupd outer))))
  (setvar "snapmode" snapp)
  (command "undo" "end")
 enam)
 ; Ŀ
 ;   Subroutine Crelm end.                                                 
 ; 

 ; Ŀ
 ;   Listi - make a list of strings into one string.                       
 ;   Arguments: Alist, a list of strings.                                  
 ;              Sepstr, the separator string.                              
 ;   Returns a string.                                                     
 ; 
 (DEFUN LISTI (alist sepstr / thestr len)
  (setq thestr "")
 ; Ŀ
 ;   You don't ever really have to have mapcar, but it is nice...          
 ; 
  (mapcar '(lambda (astr)
            (setq thestr (strcat thestr sepstr astr)))
            alist)
 ; Ŀ
 ;   Remove the extraneous copy of sepstr from the string end.             
 ; 
  (if (> (strlen thestr) (setq len (strlen sepstr)))
      (setq thestr (substr thestr (1+ len))))
 thestr)
 ; Ŀ
 ;   Listi end.                                                            
 ; 

 ; Ŀ
 ;   Monster - separate a text string into numbers and letters.            
 ;   Copyright 1992 by Rocket Software Ltd.                                
 ;   This function returns a list of strings, alternating between          
 ;   numbers and letters.  The first string is always a character string   
 ;   - if the first character is a number then the first string will be    
 ;   empty ("").                                                           
 ;   A period (.) will be interpreted as being the same type as the        
 ;   preceding character.                                                  
 ; 
 (DEFUN MONSTER (string / chastr pre ascnum posi this asc last strlist)
  (setq chastr "")
  (setq pre "c")
  (setq ascnum (list 48 49 50 51 52 53 54 55 56 57))
  (setq posi 1)
  (while (/= "" (setq this (substr string posi 1)))
       (setq asc (ascii this))
       (cond ((member asc ascnum)         ; if char is a number
              (setq last "n"))
             ((= asc 46)                  ; if char is a .
              (if (= last "c")
                  (setq last "c")
                  (setq last "n")))
             (T                           ; otherwise it must be a letter
               (setq last "c")))
 ; Ŀ
 ;   If pre = last then strcat "this" onto chastr.                         
 ;   If not then append chastr onto strlist and set chastr to this.        
 ; 
       (if (equal pre last)
           (setq chastr (strcat chastr this))
           (progn
                (if strlist
                   (setq strlist (append strlist (list chastr)))
                   (setq strlist (list chastr)))
                (setq chastr this)))
       (setq pre last)
       (setq posi (1+ posi)))
  (if chastr (setq strlist (append strlist (list chastr))))
 strlist)
 ; Ŀ
 ;   Monster end.                                                          
 ; 

 ; Ŀ
 ;   Numa - extract and total the numbers from a block or text string.     
 ;   Arguments: Enam, the entity name.                                     
 ;   Calls Nothing.                                                        
 ;   Returns a number.                                                     
 ; 
 (DEFUN NUMA (enam / typ entt tta numa)
  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
  (cond ((= typ "TEXT")
         (setq tta (asla (cdr (assoc 1 entt))))
         (if (not (zerop tta))
             (screw (spit entt))))
        ((= typ "INSERT")
         (setq tta 0)
         (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                               (setq enam (entnext enam)))))))
                (setq numa (asla (cdr (assoc 1 entt))))
                (if (not (zerop numa))
                    (progn
                         (screw (spit entt))
                         (setq tta (+ numa tta)))))))
 tta)
 ; Ŀ
 ;   Numa end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Radi - grdraw radial line set maker.                       
 ;   Does a complete circular set.                                         
 ;   Arguments: Pa, the base point.                                        
 ;              Rin, near end distance.                                    
 ;              Rout, far end distance.                                    
 ;              Reps, number of repetions in 360 degrees.                  
 ;              Stang, the start angle.                                    
 ;              Colo, the colour.                                          
 ;   Calls its mother, returns the empties.                                
 ; 
 (DEFUN RADI (pa rin rout reps stang colo / pa1 pa2)
  (setq incr (/ pi (/ reps 2)))
  (repeat reps
          (setq pa1 (polar pa stang rin))
          (setq pa2 (polar pa stang rout))
          (grdraw pa1 pa2 colo)
          (setq stang (+ stang incr)))
 (princ))
 ; Ŀ
 ;   Radi end.                                                             
 ; 

 ; Ŀ
 ;   Rlanum - replace the last number in a string.                         
 ;   Arguments: Stra, a string.                                            
 ;              Gnum, the new number.                                      
 ;   Calls Snortme/Monster & /Listi.                                       
 ;   Returns a string.                                                     
 ; 
 (DEFUN RLANUM (stra gnum / pref suff typ)
  (setq suff (snortme stra))
  (setq pref (car suff))
  (setq suff (caddr suff))
  (setq typ (type gnum))
  (cond ((= typ 'int) (setq gnum (itoa gnum)))
        ((= typ 'real) (setq gnum (rtos gnum))))
 (strcat pref gnum suff))
 ; Ŀ
 ;   Rlanum end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Screw - grdraw a screw head.                               
 ;   Arguments: Pa, the base point.                                        
 ;   Calls Ci, returns nothing.                                            
 ;   Global variables: Angg, the slot angle.                               
 ;                     Anginc, the angle increment.                        
 ;                     Rad, the head radius.                               
 ;                     Colo, the grdraw colour.                            
 ;   Note that the global variables are local to the calling function      
 ;   - they can't be declared local to Screw.                              
 ; 
 (DEFUN SCREW (pa / widang p1a p1b p2a p2b)
  (setq widang 0.15)
  (setq p1a (polar pa (+ angg widang) rad))
  (setq p1b (polar pa (+ angg widang) (- rad)))
  (setq p2a (polar pa (- angg widang) rad))
  (setq p2b (polar pa (- angg widang) (- rad)))
  (grdraw p1a p2b colo)
  (grdraw p2a p1b colo)
  (ci pa rad colo)
  (setq angg (+ angg anginc))
 (princ))
 ; Ŀ
 ;   Screw end.                                                            
 ; 

 ; Ŀ
 ;   Snortme - Split a text string around the last number it contains.     
 ;   Argument: Txt, a text string.                                         
 ;   Calls Monster and Listi.                                              
 ;   Returns a list: (string number string).                               
 ; 
 (DEFUN SNORTME (txt / txt strlst pos num gnulst pref len suff typ)
 ; Ŀ
 ;   Split the string into letters and numbers.                            
 ; 
  (setq strlst (monster txt))
 ; Ŀ
 ;   Find the last substring which is a number.                            
 ; 
  (setq pos (1- (length strlst)))
  (while (and (>= pos 0)
 ; Ŀ
 ;   (read ")") will produce an extra parenthesis error. (                 
 ; 
              (or (= (nth pos strlst) ")")   ; balance (
                  (not (member (type (read (nth pos strlst))) '(int real)))))
         (setq pos (1- pos)))
 ; Ŀ
 ;   Make the prefix string.                                               
 ; 
  (if (>= pos 0)
      (progn
           (setq num 0)
           (while (<= num (1- pos))
                  (setq gnulst (append gnulst (list (nth num strlst))))
                  (setq num (1+ num)))
           (setq pref (listi gnulst "")))
      (setq pref ""))
 ; Ŀ
 ;   Make the suffix string.                                               
 ; 
  (setq gnulst ())
  (if (<= pos (setq len (1- (length strlst))))
      (progn
           (while (> len pos)
                  (setq gnulst (cons (nth len strlst) gnulst))
                  (setq len (1- len)))
           (setq suff (listi gnulst "")))
      (setq suff ""))
 ; Ŀ
 ;   Extract the number.                                                   
 ; 
  (if (>= pos 0)
      (setq num (read (nth pos strlst))))
      (setq typ (type num))
 (list pref num suff))
 ; Ŀ
 ;   Snortme end.                                                          
 ; 

 ; Ŀ
 ;   Spit - returns the insertion point of the text entity whose data was  
 ;   passed as its sole argument.  Note that this is not necessarily the   
 ;   same as the 10 association code.                                      
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (setq yjust (cdr (assoc 73 entt)))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 

 ; Ŀ
 ;   Tota.                                                                 
 ; 
 (DEFUN C:TOTA (/ *error* rad colo anginc sparam ss num tta enam curno)
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (DEFUN *ERROR* (shk)
   (if (/= shk "Function cancelled") (write-line shk))
  (princ))
 ; Ŀ
 ;   Initialize screw settings.                                            
 ; 
  (setq rad (/ (getvar "viewsize") 80))
  (setq colo 7)
  (if (not (= (type angg) 'real))
      (setq angg 1.5))
  (setq anginc 0.47)
 ; Ŀ
 ;   Get an ss of text and blocks with attributes.                         
 ; 
  (setq sparam '((-4 . "<or") (0 . "text")
                 (-4 . "<and") (0 . "insert") (66 . 1)
                 (-4 . "and>") (-4 . "or>")))
  (write-line "Select text-like objects to count: ")
  (setq ss (ssget sparam))
 ; Ŀ
 ;   Extract the number from each string, total them.                      
 ; 
  (setq num 0)
  (setq tta 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq curno (numa enam))
         (setq tta (+ tta curno))
         (setq num (1+ num)))
 ; Ŀ
 ;   Install the total into a text entity.                                 
 ; 
  (crelm tta nil)
 (princ))